/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.das2.util.Entities;

public class PdfUnicodeTextImageTest {
    public static final String FLAT_SYMBOL = "\u266d";
    public static final String SHARP_SYMBOL = "\u266f";
    public static final String RHO = Entities.decodeEntities((String)"&rho;");
    public static final String DOUBLE_FLAT_SYMBOL = "\ud834\udd2b";
    public static final String DOUBLE_SHARP_SYMBOL = "\ud834\udd2a";

    public static void main(String[] args) throws InterruptedException {
        new PdfUnicodeTextImageTest();
        Thread.sleep(2000L);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfUnicodeTextImageTest() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("/tmp/unicode_test.pdf");
            Document document = new Document();
            PdfWriter pdf = PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            try {
                document.open();
                document.setPageSize(new Rectangle(500.0f, 800.0f));
                document.newPage();
                this.printPage(document, pdf);
            }
            finally {
                document.close();
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printPage(Document document, PdfWriter pdf) throws DocumentException {
        document.add((Element)new Chunk(" "));
        PdfContentByte contentbytes = pdf.getDirectContent();
        PdfTemplate template = contentbytes.createTemplate(500.0f, 800.0f);
        Graphics2D graphics2d = template.createGraphicsShapes(500.0f, 800.0f);
        StringPainter painter = new StringPainter(new Font("Arial Unicode MS", 0, 16));
        painter.setBounds(50, 50, 200, 100);
        painter.paint(graphics2d);
        graphics2d.dispose();
        contentbytes.addTemplate(template, 0.0f, 0.0f);
    }

    private static class StringPainter
    extends JComponent {
        private Font font;

        public StringPainter(Font font) {
            this.font = font;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setFont(this.font);
            g2.drawString("TEST: \u266d  \ud834\udd2b  " + Entities.decodeEntities((String)"&rho;"), 10, 50);
            g2.drawString("TEST: \u266f  \ud834\udd2a  " + Entities.decodeEntities((String)"&Omega;"), 10, 80);
        }
    }
}

